********************************

**Stata Codes to Replicate all tables in Alem and Woldemichael
*Paper Title: The Causal Effect of Drought on Energy Poverty
*Jan 20, 2026

********************************


use "AlemandWolde.dta, clear

est clear
********* Table 3: Impact of Income Shock on Energy Poverty

eststo: reghdfe enpov drought, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms  i.rural, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpovd drought, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms  i.rural, abs(id year) vce(cluster EA_id)


esttab using Table3, replace keep(drought) ar2 ///
    b(3) se(3) ///
    label title(Impact of Income Shock on Energy Poverty\label{tab1}) ///
    nonumbers mtitles("FE" "FE" "FE" "FE") ///
    star(* 0.10 ** 0.05 *** 0.01) ///
    stats(N r2, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
    labels(`"Observations"' `"\(R^{2}\)"'))


*** Table 4: Impact of Income Shock on Energy Poverty-Mechanism

est clear

gen lnincome=ln(percapita_income+1)
gen lnfarmincome=ln((farm_income/hhsize)+1)

eststo: reghdfe lnincome drought, abs(id year) cluster(EA_id)

eststo: reghdfe lnincome drought age MaxEducation TLU Land gender hhsize homeownd rooms i.rural, abs(id year) cluster(EA_id)

eststo: reghdfe lnfarmincome drought, abs(id year) cluster(EA_id)

eststo: reghdfe lnfarmincome drought age MaxEducation TLU Land gender hhsize homeownd rooms i.rural, abs(id year) cluster(EA_id)

esttab using Table4, replace keep(drought) ar2 ///
    b(3) se(3) ///
    label title(Impact of Income Shock on Energy Poverty-Mechanism\label{tab1}) ///
    nonumbers mtitles("FE" "FE" "FE" "FE") ///
    star(* 0.10 ** 0.05 *** 0.01) ///
    stats(N r2, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
    labels(`"Observations"' `"\(R^{2}\)"'))

	


****Table 5: Impact of Income Shock on Energy Poverty-Heterogeneous Analysis

****Male Vs Female
est clear

eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if gender==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if gender==0, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if gender==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if gender==0, abs(id year) vce(cluster EA_id)

esttab using Table5, replace keep(drought) ar2 ///
    b(3) se(3) ///
    label title(Impact of Income Shock on Energy Poverty-Heterogeneous Analysis\label{tab1}) ///
    nonumbers mtitles("FE" "FE" "FE" "FE") ///
    star(* 0.10 ** 0.05 *** 0.01) ///
    stats(N r2, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
    labels(`"Observations"' `"\(R^{2}\)"'))


***urban vs rural
est clear

eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if rural==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if rural==0, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if rural==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if rural==0, abs(id year) vce(cluster EA_id)

esttab using Table6, replace keep(drought) ar2 ///
    b(3) se(3) ///
    label title(Impact of Income Shock on Energy Poverty-Heterogeneous Analysis\label{tab1}) ///
    nonumbers mtitles("FE" "FE" "FE" "FE") ///
    star(* 0.10 ** 0.05 *** 0.01) ///
    stats(N r2, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
    labels(`"Observations"' `"\(R^{2}\)"'))




**Table 6: Impact of Income Shock on Energy Poverty-The Role PSNP


est clear

eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if psnp==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if psnp==0, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if credit==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpov drought age MaxEducation TLU Land gender hhsize homeownd rooms if credit==0, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if psnp==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if psnp==0, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if credit==1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpovd drought age MaxEducation TLU Land gender hhsize homeownd rooms if credit==0, abs(id year) vce(cluster EA_id)

esttab using Table6, replace keep(drought) ar2 ///
    b(3) se(3) ///
    label title(Impact of Income Shock on Energy Poverty-The Role PSNP\label{tab1}) ///
    nonumbers mtitles("FE" "FE" "FE" "FE") ///
    star(* 0.10 ** 0.05 *** 0.01) ///
    stats(N r2, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
    labels(`"Observations"' `"\(R^{2}\)"'))

*****Robustness checks

** Table 7: Impact of Income Shock on Energy Poverty-Robustness Checks
est clear

eststo: reghdfe enpov drought_1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpov drought_1 age MaxEducation TLU Land gender hhsize homeownd rooms i.rural, abs(id year) vce(cluster EA_id)


eststo: reghdfe enpovd drought_1, abs(id year) vce(cluster EA_id)

eststo: reghdfe enpovd drought_1 age MaxEducation TLU Land gender hhsize homeownd rooms i.rural, abs(id year) vce(cluster EA_id)

esttab using Table7, replace keep(drought_1) ar2 ///
    b(3) se(3) ///
    label title(Impact of Income Shock on Energy Poverty-Robustness Checks\label{tab1}) ///
    nonumbers mtitles("FE" "FE" "FE" "FE") ///
    star(* 0.10 ** 0.05 *** 0.01) ///
    stats(N r2, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
    labels(`"Observations"' `"\(R^{2}\)"'))



** Table 8: Impact of Income Shock on Energy Poverty-Robustness Check
est clear
 
eststo: reghdfe enpov1 drought , abs(id year) vce(cluster EA_id)

eststo: reghdfe enpov1 drought age MaxEducation TLU Land gender hhsize homeownd rooms i.rural, abs(id year) vce(cluster EA_id)

esttab using Table8, replace keep(drought) ar2 ///
    b(3) se(3) ///
    label title(Impact of Income Shock on Energy Poverty-Robustness Check\label{tab1}) ///
    nonumbers mtitles("FE" "FE" "FE" "FE") ///
    star(* 0.10 ** 0.05 *** 0.01) ///
    stats(N r2, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
    labels(`"Observations"' `"\(R^{2}\)"'))




*** Table 2: Summary statistics

est clear

estpost tabstat  enpov enpovd drought drought_1 age gender hhsize MaxEducation TLU Land homeownd rooms  rural, statistics ("mean" "sd") column(stat) 

est store total

***Column 2: Descriptive statistics for variables used in the analysis for year 2014 data 

estpost tabstat enpov enpovd drought drought_1 age gender hhsize MaxEducation TLU Land homeownd rooms  rural if year ==2013, statistics ("mean" "sd") column(stat) 

est store d2013

***Column 3: Descriptive statistics for variables used in the analysis for year 2016 data 

estpost tabstat  enpov enpovd drought drought_1 age gender hhsize MaxEducation TLU Land homeownd rooms  rural if year ==2015, statistics ("mean" "sd") column(stat) 

est store d2015


*esttab using table3.tex,  
esttab _all using table2, main(mean) aux(sd)   replace

